Ext.data.JsonP.sol_common_ix_functions_CreateGroup({"tagname":"class","name":"sol.common.ix.functions.CreateGroup","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.CreateGroup.js","href":"sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup"}],"eloix":true,"requires":["sol.common.Injection","sol.common.IxUtils","sol.common.ObjectFormatter.MapTableToArray","sol.common.Template","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.JsonUtils","sol.common.ix.ObjectUtils","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":["sol.common.mixins.Inject"],"uses":[],"members":[{"name":"addUsers","tagname":"cfg","owner":"sol.common.ix.functions.CreateGroup","id":"cfg-addUsers","meta":{}},{"name":"asAdmin","tagname":"cfg","owner":"sol.common.ix.functions.CreateGroup","id":"cfg-asAdmin","meta":{}},{"name":"groupId","tagname":"cfg","owner":"sol.common.ix.functions.CreateGroup","id":"cfg-groupId","meta":{}},{"name":"groupName","tagname":"cfg","owner":"sol.common.ix.functions.CreateGroup","id":"cfg-groupName","meta":{}},{"name":"memberOf","tagname":"cfg","owner":"sol.common.ix.functions.CreateGroup","id":"cfg-memberOf","meta":{}},{"name":"name","tagname":"cfg","owner":"sol.common.ix.functions.CreateGroup","id":"cfg-name","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"inject","tagname":"property","owner":"sol.common.ix.functions.CreateGroup","id":"property-inject","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addMemberToGroup","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"method-addMemberToGroup","meta":{"private":true}},{"name":"createGroup","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"method-createGroup","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"method-initialize","meta":{}},{"name":"prepareGroupConfig","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"method-prepareGroupConfig","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"method-process","meta":{}},{"name":"shouldSaveGroupToField","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"method-shouldSaveGroupToField","meta":{"private":true}},{"name":"RF_sol_function_CreateGroup","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"static-method-RF_sol_function_CreateGroup","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.CreateGroup","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.CreateGroup","short_doc":"Creates a new ELO group and fills it with members by default. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.CreateGroup</strong></div></div></div><h4>Mixins</h4><div class='dependency'>sol.common.mixins.Inject</div><h4>Requires</h4><div class='dependency'>sol.common.Injection</div><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray' rel='sol.common.ObjectFormatter.MapTableToArray' class='docClass'>sol.common.ObjectFormatter.MapTableToArray</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'>sol.common.ix.JsonUtils</div><div class='dependency'>sol.common.ix.ObjectUtils</div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup' target='_blank'>sol.common.ix.functions.CreateGroup.js</a></div></pre><div class='doc-contents'><p>Creates a new ELO group and fills it with members by default.\nReturns an object with the name of the group and the groupId.</p>\n\n<h3>Output</h3>\n\n<p> {\n   \"name\": \"groupname\",\n   \"groupId\": \"4711\"\n }</p>\n\n<p>If no predefined groupId is passed, one is automatically generated by ELO</p>\n\n<p>It is possible to add some members to the created group directly\n<a href=\"#!/api/sol.common.ix.functions.ChangeGroup\" rel=\"sol.common.ix.functions.ChangeGroup\" class=\"docClass\">sol.common.ix.functions.ChangeGroup</a></p>\n\n<p> {\n    addMembers: [\n      \"renz\",\n      { \"type\": \"GRP\", \"key\": \"ELOINDEX\" },\n      { \"type\", \"MAP\", \"key\": \"USERNAME\", table: true }\n     ]\n   }</p>\n\n<p>In addition when you want to add the created group is memberOf another group you can declare\nthe following configuration</p>\n\n<p>   {\n     memberOf: [sol.common.roles.StandardUsers]\n   }\nThis is really handy when you want to give some default rights to the new created groups.\nFor example the new created group should be have the role <code>StandardUsers</code></p>\n\n<p>If the group already exists, no further operations will be performed with this\ngroups. Only if the group is newly created.</p>\n\n<h3>saveToField</h3>\n\n<p>Finally save the newly created group in a field so that it can be easily retrieved later</p>\n\n<p>  {\n     saveGroupToField: { type: \"GRP\", key: \"ELOINDEX\" }\n  }</p>\n\n<p>Internal is sol.common.ix.function.Set used, so the config is delegate to the\nset function {@see sol.common.ix.function.Set#entries}.</p>\n\n<h1>As workflow node</h1>\n\n<p>ObjId is set based on the element that the workflow is attached to.\nFollowing additional configuration can be applied to the comments field.</p>\n\n<pre><code>{\n \"groupName\": \"New Group\",\n \"groupId\": \"new group id\"\n}\n</code></pre>\n\n<h1>As IX function call</h1>\n\n<p>In addition to the workflow node configuration the objId must be passed.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_function_CreateGroup\", {\n  objId: \"4712\",\n  name: \"New Group\"\n  memberOf: [ \"sol.common.roles.StandardUsers\" ],\n  addMembers: [\"renz\", \"kraft\"]\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-addUsers' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-cfg-addUsers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-cfg-addUsers' class='name expandable'>addUsers</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nAdd each user to the new created group. ...</div><div class='long'><p>(optional)\nAdd each user to the new created group. usernames could be added directly or from sord fields</p>\n</div></div></div><div id='cfg-asAdmin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-cfg-asAdmin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-cfg-asAdmin' class='name expandable'>asAdmin</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nWhen asAdmin is set to true the operation will be execute with an admin connection ...</div><div class='long'><p>(optional)\nWhen <code>asAdmin</code> is set to true the operation will be execute with an admin connection</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-groupId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-cfg-groupId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-cfg-groupId' class='name expandable'>groupId</a> : String|number<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nIf <code>groupId</code> is set the passed id will be used by creation otherwise the id will generate randomily</p>\n</div><div class='long'><p>(optional)\nIf <code>groupId</code> is set the passed id will be used by creation otherwise the id will generate randomily</p>\n</div></div></div><div id='cfg-groupName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-cfg-groupName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-cfg-groupName' class='name expandable'>groupName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>The name of the new group. ...</div><div class='long'><p>The name of the new group. Templating is possible if objId/flowId is passed to the function</p>\n</div></div></div><div id='cfg-memberOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-cfg-memberOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-cfg-memberOf' class='name expandable'>memberOf</a> : Array&lt;String&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nAssign the nwe created group to each group which contains <code>memberOf</code></p>\n</div><div class='long'><p>(optional)\nAssign the nwe created group to each group which contains <code>memberOf</code></p>\n</div></div></div><div id='cfg-name' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-cfg-name' class='name expandable'>name</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-inject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-property-inject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-property-inject' class='name expandable'>inject</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{name: {prop: &quot;groupName&quot;, template: true}, sord: {sordIdFromProp: &quot;objId&quot;, flowIdFromProp: &quot;flowId&quot;, optional: false}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addMemberToGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-method-addMemberToGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-method-addMemberToGroup' class='name expandable'>addMemberToGroup</a>( <span class='pre'>names, targetGroups</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>names</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>targetGroups</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-createGroup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-method-createGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-method-createGroup' class='name expandable'>createGroup</a>( <span class='pre'>name, groupConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>groupConfig</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>memberOf</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>memberOf</span> : String | Array&lt;String&gt;<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-prepareGroupConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-method-prepareGroupConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-method-prepareGroupConfig' class='name expandable'>prepareGroupConfig</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-shouldSaveGroupToField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-method-shouldSaveGroupToField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-method-shouldSaveGroupToField' class='name expandable'>shouldSaveGroupToField</a>( <span class='pre'>createdGroupId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>createdGroupId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_CreateGroup' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-static-method-RF_sol_function_CreateGroup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-static-method-RF_sol_function_CreateGroup' class='name expandable'>RF_sol_function_CreateGroup</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.CreateGroup'>sol.common.ix.functions.CreateGroup</span><br/><a href='source/sol.common.ix.functions.CreateGroup.html#sol-common-ix-functions-CreateGroup-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.CreateGroup-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});